/**************************************************************
* Health and Retirement Data Acqusition and Preparation for
* "Measurement Equivalence of Subjective Well-Being Scales under
* the Presence of Acquiescent Response Style for the Racially and 
* Ethnically Diverse Older Population in the United States"
* by Lee, Vsquez, Ryan and Smith
**************************************************************/

options nofmterr;

libname PAPER "LOCATION FOR DATA TO BE SAVED";

libname trk "LOCAITON FOR RAW HRS TRACKER FILE";

DATA trk;
set trk.trk2014tr_r;

HHIDPN=TRIM(HHID)||PN;

IN_10=MIWWAVE;

IF HISPANIC=0 THEN HIS=.; 
	else IF 0<HISPANIC<4 THEN HIS=1;  
	else IF HISPANIC=5 THEN HIS=0;

IF (his=. and race=.) or (in_10 ne 1) then RACETHLANG_10=.;
	else if his=1 and MIWLANG=1 THEN RACETHLANG_10=1;
	else if his=1 and MIWLANG=2 THEN RACETHLANG_10=2;
	else if his=0 & race=1 & in_10=1 then RACETHLANG_10=3;
	else if his=0 & race=2 & in_10=1 then RACETHLANG_10=4;
	else RACETHLANG_10=5;

IF MAGE>996 THEN AGE_10=.; else AGE_10=MAGE; 

IF MPROXY in (1,2,11) then PROXY_10=1; else proxy_10=.; 

IF OALIVE =. THEN ALIVE_14=.; else IF OALIVE in (1,2) THEN ALIVE_14=1; else ALIVE_14=0;

if gender=. then male=.;  else if gender=1 then male=1; else male=0;

weight_10=MWGTHH;

weight_LB_10=MLBWGTR ;

if PSYSOC10 in (1,2) then COMP_LB_10=1;
	else COMP_LB_10=0;

if IN_10=1 and racethlang_10 in (1,2,3);

keep hpid IN_10 HIS RACE RACETHLANG_10 AGE_10 
PROXY_10 ALIVE_14 MALE 
secu stratum weight_10 weight_LB_10 COMP_LB_10;
run;


libname hrs10 "LOCAITON FOR RAW HRS RESEARCH FILE H10B_R";

DATA demo; set hrs10.h10b_r;

HHIDPN=TRIM(HHID)||PN;

hpid=input(hhidpn, 20.);

if MB000 in (.,8,9) then LIFESAT_10=.;
	else if MB000=1 then LIFESAT_10=5;
	else if MB000=2 then LIFESAT_10=4;
	else if MB000=3 then LIFESAT_10=3;
	else if MB000=4 then LIFESAT_10=2;
	else if MB000=5 then LIFESAT_10=1;

keep hpid LIFESAT_10;
run;


data per; set hrs10.h10lb_r;

HHIDPN=TRIM(HHID)||PN;

hpid=input(hhidpn, 20.);

LS_CHANGENOTH_10 = MLB003E ;
LS_CLOSETOIDEAL_10 = MLB003A ;
LS_CONDEXCELL_10 = MLB003B ;
LS_IMPORTTHINGS_10 = MLB003D ;
LS_SATISFLIFE_10 = MLB003C ;


PIL_ACTIVITIESTRIVIAL_10 = MLB035B ;
PIL_DIRECTION_10 = MLB035G ;
PIL_DONEALL_10 = MLB035E ;
PIL_NOSENSE_10 = MLB035D ;
PIL_ONEDAY_10 = MLB035F ;
PIL_OWNPLANS_10 = MLB035C ;
PIL_PLANSFUTURE_10 = MLB035A ;

PAF_ACTIVE_10 = MLB027F ;
PAF_ALERT_10 = MLB027V ;
PAF_ATTENTIVE_10 = MLB027P ;
PAF_CALM_10 = MLB027X ;
PAF_CONTENT_10 = MLB027Q ;
PAF_DETERMINED_10 = MLB027C ;
PAF_ENTHUSIAS_10 = MLB027D ;
PAF_EXCITED_10 = MLB027Y ;
PAF_HAPPY_10 = MLB027K ;
PAF_HOPEFUL_10 = MLB027U ;
PAF_INSPIRED_10 = MLB027T ;
PAF_INTERESTED_10 = MLB027H ;
PAF_PROUD_10 = MLB027G ;


LS_INDEX_10 = mean(LS_CLOSETOIDEAL_10,LS_CONDEXCELL_10,LS_SATISFLIFE_10,LS_IMPORTTHINGS_10,
			LS_CHANGENOTH_10);
M_LS_INDEX_10 = nmiss(LS_CLOSETOIDEAL_10,LS_CONDEXCELL_10,LS_SATISFLIFE_10,LS_IMPORTTHINGS_10,
			LS_CHANGENOTH_10);
	if M_LS_INDEX_10>2 then LS_INDEX_10=.;

PIL_INDEX_10 = mean(PIL_PLANSFUTURE_10,PIL_ACTIVITIESTRIVIAL_10_R,PIL_OWNPLANS_10,PIL_NOSENSE_10_R,
			PIL_DONEALL_10_R,PIL_ONEDAY_10_R,PIL_DIRECTION_10);
M_PIL_INDEX_10 = nmiss(PIL_PLANSFUTURE_10,PIL_ACTIVITIESTRIVIAL_10_R,PIL_OWNPLANS_10,PIL_NOSENSE_10_R,
			PIL_DONEALL_10_R,PIL_ONEDAY_10_R,PIL_DIRECTION_10);
	if M_PIL_INDEX_10>3 then PIL_INDEX_10=.;

PAF_INDEX_10 = mean(PAF_DETERMINED_10_R,PAF_ENTHUSIAS_10_R,PAF_ACTIVE_10_R,PAF_PROUD_10_R,
			PAF_INTERESTED_10_R,PAF_HAPPY_10_R,PAF_ATTENTIVE_10_R,PAF_CONTENT_10_R,
			PAF_INSPIRED_10_R,PAF_HOPEFUL_10_R,PAF_ALERT_10_R,PAF_CALM_10_R,PAF_EXCITED_10_R);
M_PAF_INDEX_10 = nmiss(PAF_DETERMINED_10_R,PAF_ENTHUSIAS_10_R,PAF_ACTIVE_10_R,PAF_PROUD_10_R,
			PAF_INTERESTED_10_R,PAF_HAPPY_10_R,PAF_ATTENTIVE_10_R,PAF_CONTENT_10_R,
			PAF_INSPIRED_10_R,PAF_HOPEFUL_10_R,PAF_ALERT_10_R,PAF_CALM_10_R,	PAF_EXCITED_10_R);
	if M_PAF_INDEX_10>6 then PAF_INDEX_10=.;


SDL_LIFEWHOLE_10 = MLB039H ;
if SDL_LIFEWHOLE_10=. then SDL_LIFEWHOLE_10_R=.;
else SDL_LIFEWHOLE_10_R= 6-SDL_LIFEWHOLE_10;


keep hpid 

LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10
LS_SATISFLIFE_10
LS_IMPORTTHINGS_10
LS_CHANGENOTH_10

PIL_PLANSFUTURE_10
PIL_ACTIVITIESTRIVIAL_10
PIL_OWNPLANS_10
PIL_NOSENSE_10
PIL_DONEALL_10
PIL_ONEDAY_10
PIL_DIRECTION_10

PAF_DETERMINED_10
PAF_ENTHUSIAS_10
PAF_ACTIVE_10
PAF_PROUD_10
PAF_INTERESTED_10
PAF_HAPPY_10
PAF_ATTENTIVE_10
PAF_CONTENT_10
PAF_INSPIRED_10
PAF_HOPEFUL_10
PAF_ALERT_10
PAF_CALM_10
PAF_EXCITED_10

LS_INDEX_10
PIL_INDEX_10
PAF_INDEX_10

SDL_LIFEWHOLE_10_R;
run;


libname rand "LOCATION OF RAND HRS LONGITUDINAL DATA";

data rand; set rand.rndhrs_o;

hpid=input(hhidpn, 20.);

array aa R10SHLT;
array ab srh_10 ; 
array ac neghlth_10;
do over aa;
if aa=1 then ab=5; 
	else if aa=2 then ab=4;
	else if aa=3 then ab=3;
	else if aa=4 then ab=2;
	else if aa=5 then ab=1;
	else ab=.;
if ab=. then ac=.;
	else if ab in (1,2) then ac=1;
	else if ab in (3,4,5) then ac=0;
end;

array ba R10MSTAT;
array bb married_10;
do over ba;
if ba =. then bb=.;
	else if ba in (1,2) then bb=1;
	else bb=0;
end;

array ca 	R10TR20  R10CONDE  H10ATOTA;
array cb 	recall_10  numcond_10  WEALTH_ALL_10;
do over ca;
if ca in (., .D, .R, .X, .Q, .U, .V, .S, .M) then cb=.;
	else cb=ca;
end;

keep hpid 
srh_10 neghlth_10 recall_10
married_10 numcond_10 WEALTH_ALL_10;
run;
 
proc sort data=demo; by  Hpid; run;
proc sort data=trk; by  Hpid; run;
proc sort data=per; by  Hpid; run;
proc sort data=rand; by  Hpid; run;

data PAPER.HRS_SWB; 
merge demo per trk rand; 
by  hpid;
where racethlang_10 in (1,2,3);
format _all_;
run;
 
